/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.contact;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.IVWUDDIPanelOperation;
import filenet.vw.toolkit.utils.ws.contact.VWContactPhoneTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.apache.juddi.datatype.business.Contact;

public class VWContactPhonePanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWUDDIPanelOperation {
    private Contact m_contact = null;
    private Frame m_parentFrame = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_phoneTable = null;
    private VWContactPhoneTableModel m_tableModel = null;
    private boolean m_bChanged = false;

    public VWContactPhonePanel(Frame parent, Contact theContact) {
        try {
            this.m_parentFrame = parent;
            this.m_contact = theContact;
            this.createControls();
            this.m_phoneTable.clearSelection();
            if (this.m_phoneTable.getRowCount() > 0) {
                this.m_phoneTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 1));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 2));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_bChanged || this.m_tableModel.hasChanged();
    }

    public void stopEditing() {
        if (this.m_phoneTable != null) {
            this.m_phoneTable.stopEditing();
        }
    }

    public boolean validateData() {
        return this.m_tableModel.verifyPhones();
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            this.stopEditing();
            if (this.m_tableModel.hasChanged() && (bSuccess = this.m_tableModel.verifyPhones())) {
                Vector PhoneList = this.m_tableModel.getPhoneVector();
                this.m_contact.setPhoneVector(PhoneList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
        }
        return bSuccess;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                if (this.m_phoneTable.getRowCount() <= 0) break;
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_phoneTable.getSelectedRow()) {
                    this.m_phoneTable.clearSelection();
                }
                this.m_phoneTable.setRowSelectionInterval(nRow, nRow);
                this.m_phoneTable.ensureRowIsVisible(nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            JPanel clientPanel = this.m_toolBarBorder.getClientPanel();
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 1));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 2));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 2, 0x10000000));
            int nRowIndex = this.m_phoneTable.getSelectedRow();
            int nRowCount = this.m_phoneTable.getRowCount();
            if (this.m_tableModel != null && nRowIndex != -1) {
                if (nRowIndex > 0) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 1));
                }
                if (nRowIndex < nRowCount - 1) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 2));
                }
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(clientPanel, 1, 0x10000000));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_phoneTable.setRowSelectionInterval(nRow, nRow);
                    this.m_phoneTable.setColumnSelectionInterval(0, 0);
                    this.m_phoneTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                    break;
                }
                case 1: {
                    this.onUp();
                    break;
                }
                case 2: {
                    this.onDown();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createControls() {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.createDescriptionsPanel();
            this.add((Component)this.m_toolBarBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Vector getPhoneVector() {
        return this.m_tableModel.getPhoneVector();
    }

    public void resetTableData(Vector data) {
        this.m_tableModel.resetData(data);
    }

    public void releaseResources() {
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_phoneTable != null) {
            this.m_phoneTable.removeAll();
            this.m_phoneTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.removeAll();
    }

    private void createDescriptionsPanel() {
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.s_phoneNumbers, 0x10000013);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWContactPhoneTableModel(this.m_parentFrame, this.m_contact);
            this.m_tableModel.addTableModelListener(this);
            this.m_phoneTable = new VWTable(this.m_tableModel);
            this.m_phoneTable.setRowSelectionAllowed(true);
            this.m_phoneTable.getSelectionModel().addListSelectionListener(this);
            this.m_phoneTable.getSelectionModel().setSelectionMode(0);
            TableColumn tcElement = this.m_phoneTable.getColumn(this.m_tableModel.getColumnName(0));
            if (tcElement != null) {
                tcElement.setMaxWidth(20);
            }
            if ((tcElement = this.m_phoneTable.getColumn(this.m_tableModel.getColumnName(1))) != null) {
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_phoneTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.stopEditing();
            int[] rows = this.m_phoneTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
                this.m_bChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUp() {
        try {
            int nRowIndex = this.m_phoneTable.getSelectedRow();
            if (nRowIndex > 0) {
                this.m_tableModel.up(nRowIndex);
                this.m_phoneTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
                this.m_bChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDown() {
        try {
            int nRowIndex = this.m_phoneTable.getSelectedRow();
            if (nRowIndex < this.m_tableModel.getRowCount() - 1) {
                this.m_tableModel.down(nRowIndex);
                this.m_phoneTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
                this.m_bChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

